/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.sim.pdu.impl;

import com.cisco.pt.EncodedBuffer;
import com.cisco.pt.IPAddress;
import com.cisco.pt.impl.IPCResponseFactory;
import com.cisco.pt.ipc.enums.PtmpTypeValue;
import com.cisco.pt.ipc.sim.pdu.OSPFv6HelloPacket;
import com.cisco.pt.ipc.sim.pdu.OSPFv6OptionField;
import com.cisco.pt.ipc.sim.pdu.impl.OSPFv6PacketImpl;
import com.cisco.pt.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSPFv6HelloPacketImpl
extends OSPFv6PacketImpl
implements OSPFv6HelloPacket {
    protected int interfaceId;
    protected Byte priority;
    protected OSPFv6OptionField option;
    protected Short helloInterval;
    protected Short deadInterval;
    protected IPAddress designatedRouter;
    protected IPAddress backupDesignatedRouter;
    protected List<IPAddress> neighbors;

    public OSPFv6HelloPacketImpl() {
        this.fieldNames.add("OSPFv6HelloPacketImpl_interfaceId");
        this.fieldNames.add("OSPFv6HelloPacketImpl_priority");
        this.fieldNames.add("OSPFv6HelloPacketImpl_option");
        this.fieldNames.add("OSPFv6HelloPacketImpl_helloInterval");
        this.fieldNames.add("OSPFv6HelloPacketImpl_deadInterval");
        this.fieldNames.add("OSPFv6HelloPacketImpl_designatedRouter");
        this.fieldNames.add("OSPFv6HelloPacketImpl_backupDesignatedRouter");
        this.fieldNames.add("OSPFv6HelloPacketImpl_neighbors");
        this.signalType = "Ospfv6HelloPacket";
    }

    @Override
    public int getInterfaceId() {
        return this.interfaceId;
    }

    @Override
    public void setInterfaceId(int interfaceId) {
        this.interfaceId = interfaceId;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFv6HelloPacketImpl_interfaceId")) continue;
            this.fieldTable.set(i, new Pair<String, Integer>("OSPFv6HelloPacketImpl_interfaceId", interfaceId));
            return;
        }
    }

    @Override
    public Byte getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(Byte priority) {
        this.priority = priority;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFv6HelloPacketImpl_priority")) continue;
            this.fieldTable.set(i, new Pair<String, Byte>("OSPFv6HelloPacketImpl_priority", priority));
            return;
        }
    }

    @Override
    public OSPFv6OptionField getOption() {
        return this.option;
    }

    @Override
    public void setOption(OSPFv6OptionField option) {
        this.option = option;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFv6HelloPacketImpl_option")) continue;
            this.fieldTable.set(i, new Pair<String, OSPFv6OptionField>("OSPFv6HelloPacketImpl_option", option));
            return;
        }
    }

    @Override
    public Short getHelloInterval() {
        return this.helloInterval;
    }

    @Override
    public void setHelloInterval(Short helloInterval) {
        this.helloInterval = helloInterval;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFv6HelloPacketImpl_helloInterval")) continue;
            this.fieldTable.set(i, new Pair<String, Short>("OSPFv6HelloPacketImpl_helloInterval", helloInterval));
            return;
        }
    }

    @Override
    public Short getDeadInterval() {
        return this.deadInterval;
    }

    @Override
    public void setDeadInterval(Short deadInterval) {
        this.deadInterval = deadInterval;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFv6HelloPacketImpl_deadInterval")) continue;
            this.fieldTable.set(i, new Pair<String, Short>("OSPFv6HelloPacketImpl_deadInterval", deadInterval));
            return;
        }
    }

    @Override
    public IPAddress getDesignatedRouter() {
        return this.designatedRouter;
    }

    @Override
    public void setDesignatedRouter(IPAddress designatedRouter) {
        this.designatedRouter = designatedRouter;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFv6HelloPacketImpl_designatedRouter")) continue;
            this.fieldTable.set(i, new Pair<String, IPAddress>("OSPFv6HelloPacketImpl_designatedRouter", designatedRouter));
            return;
        }
    }

    @Override
    public IPAddress getBackupDesignatedRouter() {
        return this.backupDesignatedRouter;
    }

    @Override
    public void setBackupDesignatedRouter(IPAddress backupDesignatedRouter) {
        this.backupDesignatedRouter = backupDesignatedRouter;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFv6HelloPacketImpl_backupDesignatedRouter")) continue;
            this.fieldTable.set(i, new Pair<String, IPAddress>("OSPFv6HelloPacketImpl_backupDesignatedRouter", backupDesignatedRouter));
            return;
        }
    }

    @Override
    public List<IPAddress> getNeighbors() {
        return this.neighbors;
    }

    @Override
    public void setNeighbors(List<IPAddress> neighbors) {
        this.neighbors = neighbors;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFv6HelloPacketImpl_neighbors")) continue;
            this.fieldTable.set(i, new Pair<String, List<IPAddress>>("OSPFv6HelloPacketImpl_neighbors", neighbors));
            return;
        }
    }

    @Override
    public PtmpTypeValue getFieldType(String fieldName) {
        if (fieldName.equals("OSPFv6HelloPacketImpl_interfaceId")) {
            return PtmpTypeValue.INT;
        }
        if (fieldName.equals("OSPFv6HelloPacketImpl_priority")) {
            return PtmpTypeValue.BYTE;
        }
        if (fieldName.equals("OSPFv6HelloPacketImpl_option")) {
            return PtmpTypeValue.DATA;
        }
        if (fieldName.equals("OSPFv6HelloPacketImpl_helloInterval")) {
            return PtmpTypeValue.SHORT;
        }
        if (fieldName.equals("OSPFv6HelloPacketImpl_deadInterval")) {
            return PtmpTypeValue.SHORT;
        }
        if (fieldName.equals("OSPFv6HelloPacketImpl_designatedRouter")) {
            return PtmpTypeValue.IP_ADDRESS;
        }
        if (fieldName.equals("OSPFv6HelloPacketImpl_backupDesignatedRouter")) {
            return PtmpTypeValue.IP_ADDRESS;
        }
        if (fieldName.equals("OSPFv6HelloPacketImpl_neighbors")) {
            return PtmpTypeValue.DATA;
        }
        return super.getFieldType(fieldName);
    }

    private void populateFieldTable() {
        this.fieldTable.add(new Pair<String, Integer>("OSPFv6HelloPacketImpl_interfaceId", this.interfaceId));
        this.fieldTable.add(new Pair<String, Byte>("OSPFv6HelloPacketImpl_priority", this.priority));
        this.fieldTable.add(new Pair<String, OSPFv6OptionField>("OSPFv6HelloPacketImpl_option", this.option));
        this.fieldTable.add(new Pair<String, Short>("OSPFv6HelloPacketImpl_helloInterval", this.helloInterval));
        this.fieldTable.add(new Pair<String, Short>("OSPFv6HelloPacketImpl_deadInterval", this.deadInterval));
        this.fieldTable.add(new Pair<String, IPAddress>("OSPFv6HelloPacketImpl_designatedRouter", this.designatedRouter));
        this.fieldTable.add(new Pair<String, IPAddress>("OSPFv6HelloPacketImpl_backupDesignatedRouter", this.backupDesignatedRouter));
        this.fieldTable.add(new Pair<String, List<IPAddress>>("OSPFv6HelloPacketImpl_neighbors", this.neighbors));
    }

    @Override
    public void read(EncodedBuffer buffer) {
        super.read(buffer);
        this.interfaceId = this.readInt(buffer);
        this.priority = this.readByte(buffer);
        this.option = (OSPFv6OptionField)this.readIPCData(buffer);
        this.helloInterval = this.readShort(buffer);
        this.deadInterval = this.readShort(buffer);
        this.designatedRouter = this.readIPAddress(buffer);
        this.backupDesignatedRouter = this.readIPAddress(buffer);
        List<Object> tempList1 = this.readVector(buffer);
        this.neighbors = new ArrayList<IPAddress>();
        for (Object o : tempList1) {
            this.neighbors.add((IPAddress)o);
        }
        this.populateFieldTable();
    }

    @Override
    public void pduRead(EncodedBuffer buffer) {
        super.pduRead(buffer);
        this.interfaceId = this.pduReadInt(buffer);
        this.priority = this.pduReadByte(buffer);
        this.option = (OSPFv6OptionField)IPCResponseFactory.getPDUData(buffer);
        this.helloInterval = this.pduReadShort(buffer);
        this.deadInterval = this.pduReadShort(buffer);
        this.designatedRouter = this.pduReadIPAddress(buffer);
        this.backupDesignatedRouter = this.pduReadIPAddress(buffer);
        List<Object> tempList1 = this.pduReadVector(buffer, (byte)10);
        this.neighbors = new ArrayList<IPAddress>();
        for (Object o : tempList1) {
            this.neighbors.add((IPAddress)o);
        }
        this.populateFieldTable();
    }

    @Override
    public List<String> getOrderedFieldNames() {
        return Collections.unmodifiableList(this.fieldNames);
    }

    @Override
    public void encodeTypeAndPayload(EncodedBuffer buffer) {
        super.encodeTypeAndPayload(buffer);
        buffer.putInt(this.interfaceId);
        buffer.putByte(this.priority);
        if (this.option == null) {
            buffer.putString("");
        } else {
            this.option.encodeTypeAndPayload(buffer);
        }
        buffer.putShort(this.helloInterval);
        buffer.putShort(this.deadInterval);
        buffer.putIPAddress(this.designatedRouter);
        buffer.putIPAddress(this.backupDesignatedRouter);
        buffer.putInt(this.neighbors.size());
        for (IPAddress item : this.neighbors) {
            buffer.putIPAddress(item);
        }
    }
}

